Ext.data.JsonP.sol_common_ix_RfUtils({"tagname":"class","name":"sol.common.ix.RfUtils","autodetected":{"aliases":true,"alternateClassNames":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.ix.RfUtils.js","href":"lib_sol.common.ix.RfUtils.html#sol-common-ix-RfUtils"}],"extends":"sol.Base","author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"eloix":true,"requires":["sol.common.JsonUtils","sol.common.UserUtils"],"aliases":{},"alternateClassNames":[],"mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"initialize","tagname":"property","owner":"sol.common.ix.RfUtils","id":"property-initialize","meta":{}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"checkMainAdminRights","tagname":"method","owner":"sol.common.ix.RfUtils","id":"method-checkMainAdminRights","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"parseAndCheckParams","tagname":"method","owner":"sol.common.ix.RfUtils","id":"method-parseAndCheckParams","meta":{}},{"name":"stringify","tagname":"method","owner":"sol.common.ix.RfUtils","id":"method-stringify","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.ix.RfUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ix.RfUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.UserUtils' rel='sol.common.UserUtils' class='docClass'>sol.common.UserUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ix.RfUtils.html#sol-common-ix-RfUtils' target='_blank'>lib_sol.common.ix.RfUtils.js</a></div></pre><div class='doc-contents'><p>Helper functions to execute registered functions with JSON parameter</p>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.RfUtils'>sol.common.ix.RfUtils</span><br/><a href='source/lib_sol.common.ix.RfUtils.html#sol-common-ix-RfUtils-property-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.RfUtils-property-initialize' class='name expandable'>initialize</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-checkMainAdminRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.RfUtils'>sol.common.ix.RfUtils</span><br/><a href='source/lib_sol.common.ix.RfUtils.html#sol-common-ix-RfUtils-method-checkMainAdminRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.RfUtils-method-checkMainAdminRights' class='name expandable'>checkMainAdminRights</a>( <span class='pre'>user, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Check if the user has administrative rights ...</div><div class='long'><p>Check if the user has administrative rights</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : de.elo.ix.client.UserInfo|String<div class='sub-desc'><p>UserInfo, user name or ID</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>adminTicket</span> : String<div class='sub-desc'><p>Ticket of the admin connection</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-parseAndCheckParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.RfUtils'>sol.common.ix.RfUtils</span><br/><a href='source/lib_sol.common.ix.RfUtils.html#sol-common-ix-RfUtils-method-parseAndCheckParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.RfUtils-method-parseAndCheckParams' class='name expandable'>parseAndCheckParams</a>( <span class='pre'>ec, funcName, jsonStr</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Parse the given object properties and check the mandatory parameters ...</div><div class='long'><p>Parse the given object properties and check the mandatory parameters</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>Execution context</p>\n</div></li><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>Function name.</p>\n</div></li><li><span class='pre'>jsonStr</span> : String<div class='sub-desc'><p>Parameters as JSON string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-stringify' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.RfUtils'>sol.common.ix.RfUtils</span><br/><a href='source/lib_sol.common.ix.RfUtils.html#sol-common-ix-RfUtils-method-stringify' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.RfUtils-method-stringify' class='name expandable'>stringify</a>( <span class='pre'>obj, config</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Stringify the JavaScript object and handle Java objects. ...</div><div class='long'><p>Stringify the JavaScript object and handle Java objects.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>The object to stringify.</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true,"singleton":true}});